/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import com.mojang.blaze3d.platform.InputConstants;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.UUID;
import net.adventurez.entity.goal.DragonFindOwnerGoal;
import net.adventurez.entity.goal.DragonFlyRandomlyGoal;
import net.adventurez.entity.goal.DragonSitGoal;
import net.adventurez.entity.nonliving.FireBreathEntity;
import net.adventurez.init.ConfigInit;
import net.adventurez.init.ItemInit;
import net.adventurez.init.SoundInit;
import net.adventurez.init.TagInit;
import net.adventurez.mixin.accessor.LivingEntityAccessor;
import net.adventurez.network.AdventureServerPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DragonEntity
extends PathfinderMob
implements ContainerListener,
OwnableEntity {
    public static final EntityDataAccessor<Boolean> IS_FLYING = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_START_FLYING = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> CLIENT_START_FLYING = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> CLIENT_END_FLYING = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Byte> TAMEABLE_FLAGS = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final EntityDataAccessor<Boolean> HAS_SADDLE = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> HAS_CHEST = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> OTHER_EARS = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> OTHER_TAIL = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> OTHER_EYES = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> DRAGON_SIZE = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> FIRE_BREATH = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> RED_DRAGON = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean sitting;
    public boolean isFlying;
    private int startFlyingTimer = 0;
    private float dragonSideSpeed = 0.0f;
    private float dragonForwardSpeed = 0.0f;
    public int keyBind = 342;
    private float turningFloat;
    private boolean hasSaddle;
    private int healingFood;
    private SimpleContainer inventory;
    private int onGroundTicker;
    private int dragonAge;
    private int dragonAgeFoodBonus;
    private int fireBreathCooldown;
    public boolean fireBreathActive;
    private int startFlyingTime = 0;
    private int fluidTicker = 0;

    public DragonEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
        this.onChestedStatusChanged();
        this.m_252801_();
        this.f_21364_ = 10;
    }

    public static AttributeSupplier.Builder createDragonAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22281_, 9.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new DragonSitGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new DragonFindOwnerGoal(this, 0.1, 10.0f, 2.0f));
        this.f_21345_.m_25352_(3, (Goal)new DragonFlyRandomlyGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.9));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f, 0.8f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TAMEABLE_FLAGS, (Object)0);
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(IS_FLYING, (Object)false);
        this.f_19804_.m_135372_(CLIENT_END_FLYING, (Object)false);
        this.f_19804_.m_135372_(IS_START_FLYING, (Object)false);
        this.f_19804_.m_135372_(CLIENT_START_FLYING, (Object)false);
        this.f_19804_.m_135372_(HAS_SADDLE, (Object)false);
        this.f_19804_.m_135372_(HAS_CHEST, (Object)false);
        this.f_19804_.m_135372_(OTHER_EARS, (Object)false);
        this.f_19804_.m_135372_(OTHER_TAIL, (Object)false);
        this.f_19804_.m_135372_(OTHER_EYES, (Object)false);
        this.f_19804_.m_135372_(DRAGON_SIZE, (Object)1);
        this.f_19804_.m_135372_(FIRE_BREATH, (Object)false);
        this.f_19804_.m_135372_(RED_DRAGON, (Object)false);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.m_21805_() != null) {
            tag.m_128362_("DragonOwner", this.m_21805_());
        }
        tag.m_128379_("IsFlying", this.isFlying);
        tag.m_128379_("SittingDragon", this.sitting);
        tag.m_128379_("HasSaddle", this.hasSaddle);
        tag.m_128379_("HasChest", this.hasChest());
        if (this.hasChest()) {
            ListTag listTag = new ListTag();
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemStack = this.inventory.m_8020_(i);
                if (itemStack.m_41619_()) continue;
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.m_128344_("Slot", (byte)i);
                itemStack.m_41739_(compoundTag);
                listTag.add((Object)compoundTag);
            }
            tag.m_128365_("Items", (Tag)listTag);
        }
        tag.m_128405_("DragonSize", this.getSize());
        tag.m_128379_("OtherDragonEars", ((Boolean)this.m_20088_().m_135370_(OTHER_EARS)).booleanValue());
        tag.m_128379_("OtherDragonTail", ((Boolean)this.m_20088_().m_135370_(OTHER_TAIL)).booleanValue());
        tag.m_128379_("OtherDragonEyes", ((Boolean)this.m_20088_().m_135370_(OTHER_EYES)).booleanValue());
        tag.m_128379_("RedDragon", ((Boolean)this.m_20088_().m_135370_(RED_DRAGON)).booleanValue());
        tag.m_128405_("DragonAge", this.dragonAge);
        tag.m_128405_("StartFlyingTime", this.startFlyingTime);
    }

    public void m_7378_(CompoundTag tag) {
        UUID uUID2;
        super.m_7378_(tag);
        if (tag.m_128403_("DragonOwner")) {
            uUID2 = tag.m_128342_("DragonOwner");
        } else {
            String string = tag.m_128461_("DragonOwner");
            uUID2 = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)string);
        }
        if (uUID2 != null) {
            try {
                this.setOwnerUuid(uUID2);
                this.setTamed(true);
            }
            catch (Throwable var4) {
                this.setTamed(false);
            }
        }
        this.isFlying = tag.m_128471_("IsFlying");
        this.f_19804_.m_135381_(IS_FLYING, (Object)this.isFlying);
        this.sitting = tag.m_128471_("SittingDragon");
        this.setSitting(this.sitting);
        this.hasSaddle = tag.m_128471_("HasSaddle");
        this.f_19804_.m_135381_(HAS_SADDLE, (Object)this.hasSaddle);
        this.setHasChest(tag.m_128471_("HasChest"));
        if (this.hasChest()) {
            ListTag listTag = tag.m_128437_("Items", 10);
            this.onChestedStatusChanged();
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundTag = listTag.m_128728_(i);
                int j = compoundTag.m_128445_("Slot") & 0xFF;
                if (j < 0 || j >= this.inventory.m_6643_()) continue;
                this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundTag));
            }
        }
        this.setSize(tag.m_128451_("DragonSize"));
        this.f_19804_.m_135381_(OTHER_EARS, (Object)tag.m_128471_("OtherDragonEars"));
        this.f_19804_.m_135381_(OTHER_TAIL, (Object)tag.m_128471_("OtherDragonTail"));
        this.f_19804_.m_135381_(OTHER_EYES, (Object)tag.m_128471_("OtherDragonEyes"));
        this.f_19804_.m_135381_(RED_DRAGON, (Object)tag.m_128471_("RedDragon"));
        this.dragonAge = tag.m_128451_("DragonAge");
        if (this.isFlying) {
            this.startFlyingTime = tag.m_128451_("StartFlyingTime");
        }
    }

    public void m_7023_(Vec3 movementInput) {
        if (this.m_6084_()) {
            if (this.m_20160_() && this.canBeControlledByRider()) {
                LivingEntity livingEntity = this.m_6688_();
                double wrapper = Mth.m_14175_((double)((double)this.f_20883_ - (double)this.m_146908_()));
                this.m_146922_((float)((double)this.m_146908_() + wrapper));
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingEntity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = livingEntity.f_20885_;
                boolean shouldFlyUp = false;
                boolean shouldFlyDown = false;
                shouldFlyUp = ((LivingEntityAccessor)livingEntity).jumping();
                if (this.m_9236_().m_5776_() && livingEntity instanceof LocalPlayer) {
                    LocalPlayer clientPlayerEntity = (LocalPlayer)livingEntity;
                    shouldFlyDown = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)this.keyBind);
                    if (clientPlayerEntity.f_108618_.f_108570_) {
                        this.turningFloat -= 0.05f;
                    }
                    if (!clientPlayerEntity.f_108618_.f_108570_ && this.turningFloat < 0.0f) {
                        this.turningFloat = 0.0f;
                    }
                    if (clientPlayerEntity.f_108618_.f_108571_) {
                        this.turningFloat += 0.05f;
                    }
                    if (!clientPlayerEntity.f_108618_.f_108571_ && this.turningFloat > 0.0f) {
                        this.turningFloat = 0.0f;
                    }
                }
                this.m_146922_(ConfigInit.CONFIG.heavy_dragon_flight ? this.m_146908_() + Mth.m_14177_((float)this.turningFloat) : livingEntity.m_146908_());
                float f = livingEntity.f_20900_ * 0.1f;
                float g = livingEntity.f_20902_ * 0.5f;
                float flySpeed = 0.0f;
                float maxForwardSpeed = 0.6f;
                float maxSidewaysSpeed = 0.15f;
                if (this.dragonForwardSpeed < maxForwardSpeed && livingEntity.f_20902_ > 0.0f || this.dragonForwardSpeed > maxForwardSpeed * -0.3f && livingEntity.f_20902_ < 0.0f) {
                    this.dragonForwardSpeed += g * 0.04f;
                }
                if (this.dragonSideSpeed < maxSidewaysSpeed && livingEntity.f_20900_ > 0.0f || this.dragonSideSpeed > maxSidewaysSpeed * -1.0f && livingEntity.f_20900_ < 0.0f) {
                    this.dragonSideSpeed += f * 0.03f;
                }
                if (livingEntity.f_20900_ == 0.0f) {
                    this.dragonSideSpeed = 0.0f;
                }
                if (livingEntity.f_20902_ == 0.0f) {
                    this.dragonForwardSpeed = 0.0f;
                }
                if (shouldFlyUp && !this.isFlying && this.startFlyingTimer < 10) {
                    if (this.m_20069_() && this.m_204036_(FluidTags.f_13131_) > 0.5) {
                        if (!this.m_9236_().m_5776_() && this.m_146895_() instanceof ServerPlayer) {
                            ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(AdventureServerPacket.VELOCITY_PACKET, new FriendlyByteBuf(Unpooled.buffer().writeInt(this.m_19879_()).writeFloat(0.05f)));
                            ((ServerPlayer)this.m_146895_()).f_8906_.m_9829_((Packet)packet);
                        }
                    } else {
                        ++this.startFlyingTimer;
                        this.m_20088_().m_135381_(CLIENT_START_FLYING, (Object)true);
                        this.m_20088_().m_135381_(IS_START_FLYING, (Object)true);
                    }
                }
                if (!shouldFlyUp && !this.isFlying && this.startFlyingTimer > 0) {
                    --this.startFlyingTimer;
                    this.m_20088_().m_135381_(IS_START_FLYING, (Object)false);
                }
                if (this.startFlyingTimer <= 0 && !this.isFlying || this.isFlying || ((Boolean)this.m_20088_().m_135370_(IS_FLYING)).booleanValue()) {
                    this.m_20088_().m_135381_(CLIENT_START_FLYING, (Object)false);
                }
                if (!(this.startFlyingTimer < 10 || this.isFlying && ((Boolean)this.m_20088_().m_135370_(IS_FLYING)).booleanValue())) {
                    this.isFlying = true;
                    this.m_20088_().m_135381_(IS_FLYING, (Object)true);
                    this.startFlyingTimer = 0;
                    this.startFlyingTime = (int)this.m_9236_().m_46467_();
                }
                if (this.isFlying && this.m_20096_()) {
                    ++this.onGroundTicker;
                    if (this.onGroundTicker > 3) {
                        this.onGroundTicker = 0;
                        this.isFlying = false;
                        this.m_20088_().m_135381_(IS_FLYING, (Object)false);
                        this.m_20088_().m_135381_(CLIENT_END_FLYING, (Object)true);
                    }
                }
                if ((this.isFlying || ((Boolean)this.m_20088_().m_135370_(IS_FLYING)).booleanValue()) && shouldFlyUp) {
                    flySpeed = 0.15f;
                }
                if ((this.isFlying || ((Boolean)this.m_20088_().m_135370_(IS_FLYING)).booleanValue()) && shouldFlyDown) {
                    flySpeed = -0.2f;
                }
                if ((this.isFlying || ((Boolean)this.m_20088_().m_135370_(IS_FLYING)).booleanValue()) && !shouldFlyDown && !shouldFlyUp) {
                    flySpeed *= 0.4f;
                }
                if (this.m_6109_()) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    if (!((Boolean)this.m_20088_().m_135370_(IS_FLYING)).booleanValue() && !this.isFlying || this.m_20069_() && this.m_204036_(FluidTags.f_13131_) > 0.2) {
                        super.m_7023_(new Vec3((double)f, movementInput.f_82480_, (double)g));
                    } else {
                        Vec3 vec3d = ConfigInit.CONFIG.heavy_dragon_flight ? new Vec3((double)this.dragonSideSpeed, movementInput.f_82480_ + (double)flySpeed, (double)this.dragonForwardSpeed) : new Vec3((double)livingEntity.f_20900_ * 0.7, movementInput.f_82480_ + (double)flySpeed, (double)livingEntity.f_20902_ * 0.7);
                        if (this.m_20184_().m_165924_() > 0.01 && vec3d.m_7094_() < 0.001 && vec3d.m_7094_() > -0.001) {
                            this.m_20256_(this.m_20184_().m_82490_(0.95));
                        }
                        this.m_19920_(0.05f, vec3d);
                        this.m_6478_(MoverType.SELF, this.m_20184_());
                        this.m_20256_(this.m_20184_());
                    }
                } else if (livingEntity instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                this.m_267651_(false);
            } else if (this.isFlying || ((Boolean)this.m_20088_().m_135370_(IS_FLYING)).booleanValue()) {
                this.m_19920_(0.03f, movementInput);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.91f));
                double wrapper = Mth.m_14175_((double)((double)this.f_20885_ - (double)this.m_146908_()));
                this.m_146922_((float)((double)this.m_146908_() + wrapper));
                BlockPos blockPos = this.m_20183_().m_6625_(2);
                if (this.m_9236_().m_8055_(blockPos).m_60796_((BlockGetter)this.m_9236_(), blockPos)) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
                }
                if (this.m_20096_()) {
                    this.m_20088_().m_135381_(CLIENT_END_FLYING, (Object)true);
                    this.isFlying = false;
                    this.m_20088_().m_135381_(IS_FLYING, (Object)false);
                }
            } else {
                super.m_7023_(movementInput);
            }
        }
        if (this.isFlying && this.startFlyingTime != 0 && (int)(this.m_9236_().m_46467_() - (long)this.startFlyingTime) % 25 == 0) {
            this.playWingFlapSound();
        }
    }

    private boolean canBeControlledByRider() {
        return this.m_6688_() instanceof LivingEntity;
    }

    public boolean m_6147_() {
        return false;
    }

    public boolean m_142079_() {
        return false;
    }

    @Nullable
    public LivingEntity m_6688_() {
        return !this.m_20197_().isEmpty() && this.m_20197_().get(0) instanceof LivingEntity ? (LivingEntity)this.m_20197_().get(0) : null;
    }

    @Nullable
    private Vec3 m_30561_(Vec3 vec3d, LivingEntity livingEntity) {
        double d = this.m_20185_() + vec3d.f_82479_;
        double e = this.m_20191_().f_82289_;
        double f = this.m_20189_() + vec3d.f_82481_;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        block0: for (Pose entityPose : livingEntity.m_7431_()) {
            mutable.m_122169_(d, e, f);
            double g = this.m_20191_().f_82292_ + 0.75;
            do {
                double h = this.m_9236_().m_45573_((BlockPos)mutable);
                if ((double)mutable.m_123342_() + h > g) continue block0;
                if (DismountHelper.m_38439_((double)h)) {
                    AABB box = livingEntity.m_21270_(entityPose);
                    Vec3 vec3d2 = new Vec3(d, (double)mutable.m_123342_() + h, f);
                    if (DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)livingEntity, (AABB)box.m_82383_(vec3d2))) {
                        livingEntity.m_20124_(entityPose);
                        return vec3d2;
                    }
                }
                mutable.m_122173_(Direction.UP);
            } while (!((double)mutable.m_123342_() >= g));
        }
        return null;
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        Vec3 vec3d = DragonEntity.m_19903_((double)this.m_20205_(), (double)passenger.m_20205_(), (float)(this.m_146908_() + (passenger.m_5737_() == HumanoidArm.RIGHT ? 90.0f : -90.0f)));
        Vec3 vec3d2 = this.m_30561_(vec3d, passenger);
        if (vec3d2 != null) {
            return vec3d2;
        }
        Vec3 vec3d3 = DragonEntity.m_19903_((double)this.m_20205_(), (double)passenger.m_20205_(), (float)(this.m_146908_() + (passenger.m_5737_() == HumanoidArm.LEFT ? 90.0f : -90.0f)));
        Vec3 vec3d4 = this.m_30561_(vec3d3, passenger);
        return vec3d4 != null ? vec3d4 : this.m_20182_();
    }

    private void putPlayerOnBack(Player player) {
        if (!this.m_9236_().m_5776_()) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
        }
    }

    public void dragonFireBreath() {
        if (this.fireBreathCooldown <= 60) {
            ++this.fireBreathCooldown;
            if (!this.m_9236_().m_5776_()) {
                if (this.fireBreathCooldown == 1) {
                    this.m_9236_().m_6269_((Player)null, (Entity)this, SoundInit.DRAGON_BREATH_EVENT, SoundSource.HOSTILE, 1.0f, 1.0f);
                }
                if (this.fireBreathCooldown % 3 == 0) {
                    Vec3 vec3d = this.m_20171_(this.f_19860_, this.f_20885_);
                    Vec3 otherVec3d = this.m_20171_(this.f_19860_, this.f_20883_);
                    vec3d = vec3d.m_82549_(otherVec3d);
                    FireBreathEntity fireBreathEntity = new FireBreathEntity(this.m_9236_(), (LivingEntity)this, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
                    fireBreathEntity.m_7678_(this.m_20185_() + vec3d.f_82479_ * 3.0, this.m_20186_() + this.m_20191_().m_82376_() * 0.65 + (double)(this.m_146909_() > 0.0f ? -this.m_146909_() / 40.0f : -this.m_146909_() / 80.0f), this.m_20189_() + vec3d.f_82481_ * 3.0, this.m_146908_(), this.m_146909_());
                    this.m_9236_().m_7967_((Entity)fireBreathEntity);
                }
            } else if (!((Boolean)this.m_20088_().m_135370_(FIRE_BREATH)).booleanValue()) {
                this.m_20088_().m_135381_(FIRE_BREATH, (Object)true);
            }
        } else {
            this.fireBreathActive = false;
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (!this.m_6162_() && this.m_20160_()) {
            return super.m_6071_(player, hand);
        }
        if (this.m_9236_().m_5776_()) {
            boolean bl = this.isOwner((LivingEntity)player) || this.isTamed() || this.dragonFood(item) && !this.isTamed();
            return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.isTamed() && this.getSize() > 1 && this.isOwner((LivingEntity)player)) {
            if (item == Items.f_42009_ && !this.hasChest() && this.getSize() > 2) {
                this.m_9236_().m_6269_((Player)null, (Entity)this, SoundInit.EQUIP_CHEST_EVENT, SoundSource.NEUTRAL, 0.5f, 1.0f);
                this.setHasChest(true);
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (this.dragonFood(item) && this.m_21223_() < this.m_21233_() && player.m_6144_()) {
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                this.m_5634_(this.healingFood);
                return InteractionResult.SUCCESS;
            }
            if (!player.m_6144_()) {
                if (!this.hasSaddle) {
                    if (item == ItemInit.DRAGON_SADDLE) {
                        this.m_9236_().m_6269_((Player)null, (Entity)this, SoundEvents.f_12034_, SoundSource.NEUTRAL, 0.8f, 1.0f);
                        if (!player.m_7500_()) {
                            itemStack.m_41774_(1);
                        }
                        this.hasSaddle = true;
                        this.m_20088_().m_135381_(HAS_SADDLE, (Object)true);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.FAIL;
                }
                this.setSitting(false);
                this.putPlayerOnBack(player);
                return InteractionResult.SUCCESS;
            }
            if (this.isInSittingPose()) {
                this.setSitting(false);
                return InteractionResult.SUCCESS;
            }
            if (this.m_20096_()) {
                this.setSitting(true);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (this.dragonFood(item)) {
            if (!this.isTamed()) {
                int tamer;
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                if (this.f_19796_.m_188503_(tamer = item == ItemInit.ORC_SKIN ? 1 : this.healingFood) == 0) {
                    this.setOwner(player);
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
                return InteractionResult.SUCCESS;
            }
            if (this.canEatFood(this.dragonAge, 3, 13)) {
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                ++this.dragonAgeFoodBonus;
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return super.m_6071_(player, hand);
    }

    private boolean dragonFood(Item item) {
        if (item == ItemInit.ORC_SKIN) {
            this.healingFood = 6;
            return true;
        }
        if (item == Items.f_42485_ || item == Items.f_42579_ || item == ItemInit.MAMMOTH_MEAT || item == ItemInit.RAW_VENISON || item == ItemInit.RHINO_MEAT || item == ItemInit.WARTHOG_MEAT || item == ItemInit.ENDER_WHALE_MEAT) {
            this.healingFood = 5;
            return true;
        }
        if (item == Items.f_42658_ || item == Items.f_42581_ || item == ItemInit.IGUANA_MEAT) {
            this.healingFood = 4;
            return true;
        }
        if (item == Items.f_42697_) {
            this.healingFood = 3;
            return true;
        }
        return false;
    }

    private boolean canEatFood(int age, int minAge, int maxAge) {
        return age < minAge || age < maxAge && age > maxAge - minAge * 2;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            if (this.getSize() < 3) {
                if (this.f_19797_ % 1200 == 0) {
                    ++this.dragonAge;
                }
                if (this.dragonAge == 5 && this.getSize() == 1) {
                    this.setSize(2);
                    this.healDragonIfGrowing();
                }
                if (this.dragonAge == 15 && this.getSize() == 2) {
                    this.setSize(3);
                    this.healDragonIfGrowing();
                }
                if (this.dragonAgeFoodBonus > 5) {
                    this.dragonAgeFoodBonus = 0;
                    ++this.dragonAge;
                    this.m_9236_().m_7605_((Entity)this, (byte)9);
                }
            }
            if (this.m_20069_() || this.m_20077_()) {
                if (this.isFlying && this.m_204036_(FluidTags.f_13131_) > 1.2) {
                    ++this.fluidTicker;
                    if (this.fluidTicker >= 30) {
                        this.isFlying = false;
                        this.m_20088_().m_135381_(IS_FLYING, (Object)false);
                        this.m_20088_().m_135381_(IS_START_FLYING, (Object)false);
                        this.m_20088_().m_135381_(CLIENT_START_FLYING, (Object)false);
                        this.m_20088_().m_135381_(CLIENT_END_FLYING, (Object)false);
                        this.startFlyingTimer = 0;
                        this.fluidTicker = 0;
                    }
                } else if (this.m_9236_().m_5776_() && this.m_20160_() && !this.isFlying && this.m_204036_(FluidTags.f_13131_) > 1.0) {
                    this.m_5997_(0.0, 0.05, 0.0);
                }
            } else if (this.fluidTicker != 0) {
                this.fluidTicker = 0;
            }
        }
        if (this.fireBreathCooldown > 60) {
            ++this.fireBreathCooldown;
            if (((Boolean)this.m_20088_().m_135370_(FIRE_BREATH)).booleanValue()) {
                this.m_20088_().m_135381_(FIRE_BREATH, (Object)false);
            }
            if (this.fireBreathCooldown >= 120) {
                this.fireBreathCooldown = 0;
            }
        }
        if (this.fireBreathActive) {
            this.dragonFireBreath();
        }
    }

    private void healDragonIfGrowing() {
        if (this.m_21223_() < this.m_21233_()) {
            this.m_21153_(this.m_21223_() + 20.0f);
        }
    }

    public boolean m_6094_() {
        return !this.m_20160_();
    }

    public boolean m_6573_(Player player) {
        return !this.m_21523_();
    }

    @Environment(value=EnvType.CLIENT)
    protected void showEmoteParticle(boolean positive) {
        SimpleParticleType particleEffect = ParticleTypes.f_123750_;
        if (!positive) {
            particleEffect = ParticleTypes.f_123762_;
        }
        for (int i = 0; i < 7; ++i) {
            double d = this.f_19796_.m_188583_() * 0.02;
            double e = this.f_19796_.m_188583_() * 0.02;
            double f = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)particleEffect, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d, e, f);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void m_7822_(byte status) {
        if (status == 7 || status == 9) {
            this.showEmoteParticle(true);
        } else if (status == 6) {
            this.showEmoteParticle(false);
        } else {
            super.m_7822_(status);
        }
    }

    public boolean isTamed() {
        return ((Byte)this.f_19804_.m_135370_(TAMEABLE_FLAGS) & 4) != 0;
    }

    public void setTamed(boolean tamed) {
        byte b = (Byte)this.f_19804_.m_135370_(TAMEABLE_FLAGS);
        if (tamed) {
            this.f_19804_.m_135381_(TAMEABLE_FLAGS, (Object)((byte)(b | 4)));
        } else {
            this.f_19804_.m_135381_(TAMEABLE_FLAGS, (Object)((byte)(b & 0xFFFFFFFB)));
        }
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUuid(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public void setOwner(Player player) {
        this.setTamed(true);
        this.setOwnerUuid(player.m_20148_());
    }

    @Nullable
    public LivingEntity m_269323_() {
        try {
            UUID uUID = this.m_21805_();
            return uUID == null ? null : this.m_9236_().m_46003_(uUID);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean m_6779_(LivingEntity target) {
        return this.isOwner(target) ? false : super.m_6779_(target);
    }

    public boolean isOwner(LivingEntity entity) {
        return entity == this.m_269323_();
    }

    public boolean m_7307_(Entity other) {
        if (this.isTamed()) {
            LivingEntity livingEntity = this.m_269323_();
            if (other == livingEntity) {
                return true;
            }
            if (livingEntity != null) {
                return livingEntity.m_7307_(other);
            }
        }
        return super.m_7307_(other);
    }

    public void m_6667_(DamageSource source) {
        if (!this.m_9236_().m_5776_()) {
            if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && this.m_269323_() instanceof ServerPlayer) {
                this.m_269323_().m_213846_(this.m_21231_().m_19293_());
            }
            if (FabricLoader.getInstance().isModLoaded("dragonloot")) {
                this.m_19983_(new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("dragonloot", "dragon_scale")), (int)((float)this.getSize() * this.m_9236_().m_213780_().m_188501_())));
            }
        }
        super.m_6667_(source);
    }

    public boolean isInSittingPose() {
        return ((Byte)this.f_19804_.m_135370_(TAMEABLE_FLAGS) & 1) != 0;
    }

    private void setInSittingPose(boolean inSittingPose) {
        this.sitting = inSittingPose;
        byte b = (Byte)this.f_19804_.m_135370_(TAMEABLE_FLAGS);
        if (inSittingPose) {
            this.f_19804_.m_135381_(TAMEABLE_FLAGS, (Object)((byte)(b | 1)));
        } else {
            this.f_19804_.m_135381_(TAMEABLE_FLAGS, (Object)((byte)(b & 0xFFFFFFFE)));
        }
    }

    public void setSitting(boolean sitting) {
        this.sitting = sitting;
        this.setInSittingPose(sitting);
    }

    public int m_8132_() {
        if (this.isInSittingPose()) {
            return 20;
        }
        return super.m_8132_();
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
        if (!this.m_9236_().m_5776_() && !this.isFlying && !onGround && heightDifference < -0.7) {
            if (this.sitting) {
                this.setSitting(false);
            }
            if (!this.m_20160_()) {
                this.isFlying = true;
                this.m_20088_().m_135381_(IS_FLYING, (Object)true);
                this.m_20088_().m_135381_(IS_START_FLYING, (Object)false);
                this.m_20088_().m_135381_(CLIENT_START_FLYING, (Object)false);
                this.startFlyingTime = (int)this.m_9236_().m_46467_();
            }
        }
        super.m_7840_(heightDifference, onGround, landedState, landedPosition);
    }

    private void playWingFlapSound() {
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_11893_, this.m_5720_(), 5.0f, 0.8f + this.f_19796_.m_188501_() * 0.3f);
    }

    public void setKeyBind(String key) {
        this.keyBind = InputConstants.m_84851_((String)key).m_84873_();
    }

    protected SoundEvent m_7515_() {
        return SoundInit.DRAGON_IDLE_EVENT;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundInit.DRAGON_HIT_EVENT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.DRAGON_DEATH_EVENT;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundInit.DRAGON_STEP_EVENT, 0.7f, 1.0f);
    }

    protected float m_6059_() {
        return (float)((int)this.f_19788_ + 2) - 0.01f;
    }

    public boolean m_6785_(double num) {
        return false;
    }

    public void m_5757_(Container sender) {
    }

    private void onChestedStatusChanged() {
        SimpleContainer simpleInventory = this.inventory;
        this.inventory = new SimpleContainer(27);
        if (simpleInventory != null) {
            simpleInventory.m_19181_((ContainerListener)this);
            int i = Math.min(simpleInventory.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemStack = simpleInventory.m_8020_(j);
                if (itemStack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemStack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemStack = this.inventory.m_8020_(i);
                if (itemStack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemStack)) continue;
                this.m_19983_(itemStack);
            }
        }
        if (this.hasChest()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_19998_((ItemLike)Blocks.f_50087_);
            }
            this.setHasChest(false);
        }
    }

    public boolean hasChest() {
        return (Boolean)this.f_19804_.m_135370_(HAS_CHEST);
    }

    public void setHasChest(boolean hasChest) {
        this.f_19804_.m_135381_(HAS_CHEST, (Object)hasChest);
    }

    public void openInventory(Player player) {
        if (!this.m_9236_().m_5776_() && (!this.m_20160_() || this.m_20363_((Entity)player)) && this.isTamed()) {
            player.m_5893_((MenuProvider)new SimpleMenuProvider((syncId, inv, p) -> new ChestMenu(MenuType.f_39959_, syncId, p.m_150109_(), (Container)this.inventory, 3), this.m_7755_()));
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityTag) {
        this.m_20088_().m_135381_(OTHER_EARS, (Object)world.m_213780_().m_188499_());
        this.m_20088_().m_135381_(OTHER_TAIL, (Object)world.m_213780_().m_188499_());
        this.m_20088_().m_135381_(OTHER_EYES, (Object)world.m_213780_().m_188499_());
        if (world.m_6042_().f_63857_()) {
            this.m_20088_().m_135381_(RED_DRAGON, (Object)world.m_213780_().m_188499_());
        }
        if (spawnReason.equals((Object)MobSpawnType.COMMAND)) {
            this.setSize(3);
        } else {
            this.setSize(1);
        }
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityTag);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_((float)this.getSize() / 3.0f);
    }

    public int getSize() {
        return (Integer)this.f_19804_.m_135370_(DRAGON_SIZE);
    }

    public void setSize(int size) {
        this.f_19804_.m_135381_(DRAGON_SIZE, (Object)size);
        this.m_20090_();
        this.m_6210_();
        this.m_21051_(Attributes.f_22276_).m_22100_((double)(size * 20));
        this.m_21051_(Attributes.f_22281_).m_22100_((double)size * 3.0);
        this.m_21051_(Attributes.f_22284_).m_22100_((double)size * 2.0);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (DRAGON_SIZE.equals(data)) {
            this.m_6210_();
            this.m_146922_(this.f_20885_);
            this.m_5618_(this.f_20885_);
        }
        super.m_7350_(data);
    }

    public void m_6210_() {
        double d = this.m_20185_();
        double e = this.m_20186_();
        double f = this.m_20189_();
        super.m_6210_();
        this.m_20248_(d, e, f);
    }

    protected float m_6121_() {
        return 0.3f * (float)this.getSize();
    }

    public float m_6100_() {
        return 1.6f - 0.2f * (float)this.getSize();
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        if (this.getSize() == 1) {
            return 0.8f * dimensions.f_20378_;
        }
        return 0.85f * dimensions.f_20378_;
    }

    public double m_6048_() {
        double flySubtraction = 0.92;
        if (this.isFlying) {
            flySubtraction = 0.9;
        }
        return (double)this.getSize() * 0.794 * flySubtraction;
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction positionUpdater) {
        super.m_19956_(passenger, positionUpdater);
        if (passenger instanceof Mob) {
            Mob mobEntity = (Mob)passenger;
            this.f_20883_ = mobEntity.f_20883_;
            if (this.m_9236_().m_5776_()) {
                float offSet = 12.0f;
                if (passenger.equals((Object)this.m_6688_())) {
                    offSet = 1.0f;
                }
                float f = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180))) * offSet;
                float g = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180))) * offSet;
                passenger.m_6034_(this.m_20185_() + (double)(0.1f * f), this.m_20227_(0.66f) + passenger.m_6049_(), this.m_20189_() - (double)(0.1f * g));
            }
        }
    }

    public double m_6049_() {
        return 0.0;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(TagInit.IS_WALL)) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setSitting(false);
        }
        return this.m_6673_(source) ? false : super.m_6469_(source, amount);
    }

    public EntityGetter m_9236_() {
        return this.m_9236_();
    }

    @Environment(value=EnvType.CLIENT)
    public static void flyDragonDown(LocalPlayer player, String keyString) {
        if (player.m_20202_() != null && player.m_20202_() instanceof DragonEntity) {
            ((DragonEntity)player.m_20202_()).setKeyBind(keyString);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void dragonFireBreath(LocalPlayer player) {
        DragonEntity dragonEntity;
        if (player.m_20202_() != null && player.m_20202_() instanceof DragonEntity && player.m_20202_().m_6084_() && (Integer)(dragonEntity = (DragonEntity)player.m_20202_()).m_20088_().m_135370_(DRAGON_SIZE) >= 3) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeInt(player.m_20202_().m_19879_());
            ServerboundCustomPayloadPacket packet = new ServerboundCustomPayloadPacket(AdventureServerPacket.FIRE_BREATH_PACKET, buf);
            Minecraft.m_91087_().m_91403_().m_104955_((Packet)packet);
            ((DragonEntity)player.m_20202_()).fireBreathActive = true;
        }
    }
}

